/*
 * Decompiled with CFR 0.152.
 */
package Entity;

import Audio.AudioPlayer;
import Entity.Beam;
import Entity.Bullet;
import Entity.Collectable;
import Entity.Enemy;
import Entity.Explosion;
import Entity.GameObject;
import Entity.Missile;
import Entity.PlayerSave;
import Entity.TripleBullet;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class Player
extends GameObject {
    private int health;
    private int maxHealth;
    private boolean flinching;
    private long flinchTimer;
    private boolean dead;
    private double maxSpeedDefault = 4.0;
    private double maxSpeedBeam = 1.0;
    private boolean shoot;
    private boolean shotOnce;
    private ArrayList<Bullet> bullets;
    private int bulletMax = 5;
    private int bulletsFired = 0;
    private ArrayList<TripleBullet> tripleBullets;
    private Beam beam;
    private ArrayList<Missile> missiles;
    private int missileMax = 5;
    private ArrayList<Explosion> explosions;
    private ArrayList<BufferedImage[]> sprites;
    private BufferedImage[] destroyedSprites;
    private final int[] numFrames = new int[]{3, 3, 3};
    private static final int UP = 0;
    private static final int FORWARD = 1;
    private static final int DOWN = 2;
    private static final int DYING = 3;
    private static final int NUMACTIONS = 3;

    public Player() {
        this.width = 43;
        this.height = 41;
        this.cwidth = 40;
        this.cheight = 40;
        this.moveSpeed = 0.8;
        this.maxSpeed = 4.0;
        this.stopSpeed = 1.0;
        this.maxHealth = 3;
        this.health = 3;
        this.dead = false;
        this.bullets = new ArrayList();
        this.tripleBullets = new ArrayList();
        this.missiles = new ArrayList();
        this.explosions = new ArrayList();
        this.beam = new Beam();
        try {
            BufferedImage spritesheet = ImageIO.read(this.getClass().getResourceAsStream("/Sprites/Player/Spaceship_sprite.png"));
            this.sprites = new ArrayList();
            int i = 0;
            while (i < 3) {
                BufferedImage[] bi = new BufferedImage[this.numFrames[i]];
                int j = 0;
                while (j < this.numFrames[i]) {
                    bi[j] = spritesheet.getSubimage(j * this.width, i * this.height, this.width, this.height);
                    ++j;
                }
                this.sprites.add(bi);
                ++i;
            }
            BufferedImage destroyedspritesheet = ImageIO.read(this.getClass().getResourceAsStream("/Sprites/Player/Death.png"));
            this.destroyedSprites = new BufferedImage[12];
            int i2 = 0;
            while (i2 < 12) {
                this.destroyedSprites[i2] = destroyedspritesheet.getSubimage(i2 * 110, 0, 110, 102);
                ++i2;
            }
            AudioPlayer.load("/SFX/shot.mp3", "shot");
            AudioPlayer.load("/SFX/shot.mp3", "shot2");
            AudioPlayer.load("/SFX/Beam.mp3", "beam");
            AudioPlayer.load("/SFX/lost.mp3", "lost");
            AudioPlayer.load("/SFX/boom.mp3", "boom");
            AudioPlayer.load("/SFX/Missile.mp3", "missile");
            AudioPlayer.load("/SFX/PowerUp.mp3", "powerUp");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.currentAction = 1;
        this.animation.setFrames(this.sprites.get(1));
        this.animation.setFrame(0);
        this.animation.setDelay(-1L);
    }

    public int getHealth() {
        return this.health;
    }

    public int getMaxHealth() {
        return this.maxHealth;
    }

    public void setShooting(boolean b) {
        this.shoot = b;
    }

    public boolean getDead() {
        return this.dead;
    }

    public void checkAttack(ArrayList<Enemy> enemies, ArrayList<Collectable> collectables) {
        int i = 0;
        while (i < enemies.size()) {
            Enemy e = enemies.get(i);
            if (e.getType() == 0) {
                int j = 0;
                while (j < this.bullets.size()) {
                    if (this.bullets.get(j).intersects(e)) {
                        e.hit(1, e.getID());
                        this.bullets.get(j).setVector(0.0, 0.0);
                        break;
                    }
                    ++j;
                }
                j = 0;
                while (j < this.tripleBullets.size()) {
                    if (this.tripleBullets.get(j).intersects(e)) {
                        e.hit(2, e.getID());
                        this.tripleBullets.get(j).setVector(0.0, 0.0);
                        break;
                    }
                    ++j;
                }
                j = 0;
                while (j < this.missiles.size()) {
                    if (this.missiles.get(j).intersects(e)) {
                        e.hit(3, e.getID());
                        this.missiles.get(j).setVector(0.0, 0.0);
                        if (e.getID() == 3) break;
                        Explosion ex = new Explosion(0);
                        ex.setPosition(e.getx(), e.gety());
                        this.explosions.add(ex);
                        break;
                    }
                    ++j;
                }
                j = 0;
                while (j < this.explosions.size()) {
                    if (this.explosions.get(j).intersects(e)) {
                        e.hit(3, e.getID());
                        break;
                    }
                    ++j;
                }
                if (this.beam.intersects(e)) {
                    e.hit(5, e.getID());
                }
                if (this.intersects(e) && !this.flinching) {
                    this.hit(e.getDamage());
                    e.hit(1, e.getID());
                }
            } else if (e.getType() == 1 && this.intersects(e) && !this.flinching) {
                this.hit(e.getDamage());
                e.hit(1, e.getID());
            }
            ++i;
        }
        i = 0;
        while (i < collectables.size()) {
            Collectable c = collectables.get(i);
            if (this.intersects(c)) {
                if (c.getID() == 0) {
                    if (c.getPower() == 1) {
                        PlayerSave.addAmmo(3);
                    } else if (c.getPower() == 2) {
                        PlayerSave.addAmmo(1);
                    } else if (c.getPower() == 3) {
                        PlayerSave.addAmmo(2);
                    }
                    AudioPlayer.play("powerUp", 1.0);
                } else if (c.getID() == 1) {
                    PlayerSave.addHealth(1);
                    AudioPlayer.play("powerUp", 1.0);
                }
                c.setVector(0.0, 0.0);
                c.setRemove(true);
            }
            ++i;
        }
    }

    public void hit(int damage) {
        if (this.flinching) {
            return;
        }
        PlayerSave.addHealth(damage);
        this.flinching = true;
        this.flinchTimer = System.nanoTime();
    }

    private void getNextPosition() {
        if (this.left) {
            this.dx -= this.moveSpeed;
            if (this.dx < -this.maxSpeed) {
                this.dx = -this.maxSpeed;
            }
        } else if (this.right) {
            this.dx += this.moveSpeed;
            if (this.dx > this.maxSpeed) {
                this.dx = this.maxSpeed;
            }
        } else if (this.dx > 0.0) {
            this.dx -= this.stopSpeed;
            if (this.dx < 0.0) {
                this.dx = 0.0;
            }
        } else if (this.dx < 0.0) {
            this.dx += this.stopSpeed;
            if (this.dx > 0.0) {
                this.dx = 0.0;
            }
        }
        if (this.up) {
            this.dy -= this.moveSpeed;
            if (this.dy < -this.maxSpeed) {
                this.dy = -this.maxSpeed;
            }
        } else if (this.down) {
            this.dy += this.moveSpeed;
            if (this.dy > this.maxSpeed) {
                this.dy = this.maxSpeed;
            }
        } else if (this.dy > 0.0) {
            this.dy -= this.stopSpeed;
            if (this.dy < 0.0) {
                this.dy = 0.0;
            }
        } else if (this.dy < 0.0) {
            this.dy += this.stopSpeed;
            if (this.dy > 0.0) {
                this.dy = 0.0;
            }
        }
    }

    public void update() {
        this.maxSpeed = this.beam.getOn() ? this.maxSpeedBeam : this.maxSpeedDefault;
        this.getNextPosition();
        this.checkTileMapCollision();
        if (this.currentAction != 3) {
            long elapsed;
            this.x = this.x + this.dx < 0.0 ? 0.0 : (this.x + this.dx + (double)this.width > 800.0 ? (double)(800 - this.width) : (this.x += this.dx));
            this.y = this.y + this.dy < 0.0 ? 0.0 : (this.y + this.dy + (double)this.height > 400.0 ? (double)(400 - this.height) : (this.y += this.dy));
            if (this.flinching && (elapsed = (System.nanoTime() - this.flinchTimer) / 1000000L) > 1000L) {
                this.flinching = false;
            }
            if (!this.shoot) {
                this.shotOnce = false;
            }
            if (PlayerSave.getPowerUpState() == 0) {
                if (this.shoot && !this.shotOnce && this.bullets.size() <= this.bulletMax) {
                    if (PlayerSave.getPowerUpState() == 1 && PlayerSave.getAmmo(1) <= 0) {
                        PlayerSave.setPowerUpState(0);
                        return;
                    }
                    this.shotOnce = true;
                    Bullet bl = new Bullet();
                    bl.setPosition(this.x + (double)(this.width / 2) - (double)(bl.getWidth() / 2), this.y + (double)(this.height / 2) - (double)(bl.getHeight() / 2));
                    this.bullets.add(bl);
                    if (this.bulletsFired % 2 == 0) {
                        AudioPlayer.play("shot", 1.0);
                    } else {
                        AudioPlayer.play("shot2", 1.0);
                    }
                    ++this.bulletsFired;
                }
            } else if (PlayerSave.getPowerUpState() == 1) {
                if (this.shoot && !this.shotOnce && this.bullets.size() <= this.bulletMax) {
                    if (PlayerSave.getPowerUpState() == 1 && PlayerSave.getAmmo(1) <= 0) {
                        PlayerSave.setPowerUpState(0);
                        return;
                    }
                    this.shotOnce = true;
                    TripleBullet tb = new TripleBullet();
                    tb.setPosition(this.x + (double)(this.width / 2) - (double)(tb.getWidth() / 2), this.y + (double)(this.height / 2) - (double)(tb.getHeight() / 2));
                    this.tripleBullets.add(tb);
                    PlayerSave.subAmmo(1, 1);
                    if (this.bulletsFired % 2 == 0) {
                        AudioPlayer.play("shot", 1.0);
                    } else {
                        AudioPlayer.play("shot2", 1.0);
                    }
                    ++this.bulletsFired;
                }
            } else if (PlayerSave.getPowerUpState() == 3) {
                if (this.shoot) {
                    if (PlayerSave.getAmmo(3) <= 0) {
                        PlayerSave.setPowerUpState(0);
                        return;
                    }
                    if (!this.beam.getOn()) {
                        AudioPlayer.loop("beam", 1.0);
                    }
                    this.beam.setx((int)this.x + this.width + 3);
                    this.beam.sety((int)this.y + this.height / 2 - 6);
                    this.beam.setOn(true);
                    PlayerSave.subAmmo(3, 1);
                } else {
                    this.beam.setOn(false);
                    AudioPlayer.stop("beam");
                }
            } else if (PlayerSave.getPowerUpState() == 2 && this.shoot && !this.shotOnce && this.missiles.size() <= this.missileMax) {
                if (PlayerSave.getAmmo(2) <= 0) {
                    PlayerSave.setPowerUpState(0);
                    return;
                }
                AudioPlayer.play("missile", 1.0);
                this.shotOnce = true;
                Missile ms = new Missile();
                ms.setPosition(this.x + (double)(this.width / 2), this.y + 20.0);
                this.missiles.add(ms);
                PlayerSave.subAmmo(2, 1);
            }
            if (PlayerSave.getPowerUpState() != 3) {
                AudioPlayer.stop("beam");
                this.beam.setOn(false);
            }
            if (this.up) {
                if (this.currentAction != 0) {
                    this.currentAction = 0;
                    this.animation.setFrames(this.sprites.get(0));
                    this.animation.setDelay(-1L);
                }
                if (this.left) {
                    this.animation.setFrame(2);
                } else if (this.right) {
                    this.animation.setFrame(1);
                } else {
                    this.animation.setFrame(0);
                }
            } else if (this.down) {
                if (this.currentAction != 2) {
                    this.currentAction = 2;
                    this.animation.setFrames(this.sprites.get(2));
                    this.animation.setDelay(-1L);
                }
                if (this.left) {
                    this.animation.setFrame(2);
                } else if (this.right) {
                    this.animation.setFrame(1);
                } else {
                    this.animation.setFrame(0);
                }
            } else {
                if (this.currentAction != 1) {
                    this.currentAction = 1;
                    this.animation.setFrames(this.sprites.get(1));
                    this.animation.setDelay(-1L);
                }
                if (this.left) {
                    this.animation.setFrame(2);
                } else if (this.right) {
                    this.animation.setFrame(1);
                } else {
                    this.animation.setFrame(0);
                }
            }
        }
        this.beam.update();
        int i = 0;
        while (i < this.bullets.size()) {
            this.bullets.get(i).update();
            if (this.bullets.get(i).shouldRemove()) {
                this.bullets.remove(i);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < this.tripleBullets.size()) {
            this.tripleBullets.get(i).update();
            if (this.tripleBullets.get(i).shouldRemove()) {
                this.tripleBullets.remove(i);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < this.missiles.size()) {
            this.missiles.get(i).update();
            if (this.missiles.get(i).shouldRemove()) {
                this.missiles.remove(i);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < this.explosions.size()) {
            this.explosions.get(i).update();
            if (this.explosions.get(i).shouldRemove()) {
                this.explosions.remove(i);
                --i;
            }
            ++i;
        }
        if (PlayerSave.getHealth() <= 0 && this.currentAction != 3) {
            this.currentAction = 3;
            this.width = 110;
            this.height = 102;
            this.cwidth = 0;
            this.cheight = 0;
            this.tweakx = -38;
            this.tweaky = -38;
            this.beam.setOn(false);
            AudioPlayer.stop("beam");
            AudioPlayer.play("lost", 1.0);
            this.animation.setFrames(this.destroyedSprites);
            this.animation.setDelay(150L);
            this.dx = 0.0;
        }
        this.animation.update();
        if (this.animation.getFrames() == this.destroyedSprites && this.animation.hasPlayedOnce()) {
            this.dead = true;
        }
    }

    @Override
    public void draw(Graphics2D g) {
        long elapsed;
        int i = 0;
        while (i < this.bullets.size()) {
            this.bullets.get(i).draw(g);
            ++i;
        }
        i = 0;
        while (i < this.tripleBullets.size()) {
            this.tripleBullets.get(i).draw(g);
            ++i;
        }
        i = 0;
        while (i < this.missiles.size()) {
            this.missiles.get(i).draw(g);
            ++i;
        }
        i = 0;
        while (i < this.explosions.size()) {
            this.explosions.get(i).draw(g);
            ++i;
        }
        if (this.currentAction != 3) {
            this.beam.draw(g);
        }
        if (this.flinching && this.animation.getFrames() != this.destroyedSprites && (elapsed = (System.nanoTime() - this.flinchTimer) / 1000000L) / 100L % 2L == 0L) {
            return;
        }
        super.draw(g);
    }
}

